package apple2;
/*
 * This class interfaces directly with the console and serial port device drivers
 * for functiuonality testing and upmost performance.
 */
public class Mouse
{
	static int      slot;
	static int      mouseSlot, mouseCtrl;

	public static boolean enable()
	{
		//
		// Search for mouse card and disable VBL interrupts
		//
		for (slot = 1; slot < 8; slot++)
		{
			int mouse = vm02.call(1, 0x90 + (slot << 1)); // ID device
			if ((mouse & 0x010000FF) == 0x20) // CARRY clear == valid device IOCTL, 0x20 == mouse card ID
			{
				mouseCtrl  = 0x90 + (slot << 1);
				mouseSlot  = slot << 16;
				vm02.call(mouseSlot | 2, mouseCtrl); // init port
				return (vm02.call(mouseSlot | 3, mouseCtrl) & 0x01000000) == 0; // enable port
			}
		}
		slot = 0;
		return false;
	}
	public static void disable()
	{
		vm02.call(mouseSlot | 4, mouseCtrl); // disable port
	}
	public static void disableIRQ()
	{
		int vblSlot, vbl;
		//
		// Search for mouse card and disable/remove interrupts
		//
		for (vblSlot = 1; vblSlot < 8; vblSlot++)
		{
			vbl = vm02.call(1, 0x90 + (vblSlot << 1)); // ID device
			if ((vbl & 0x010000FF) == 0x20) // CARRY clear == valid device IOCTL, 0x20 == mouse card ID
			{
				vm02.call((vblSlot << 16) | 17, 0x90 + (vblSlot << 1)); // MOUSECTL_UNVBL
				break;
			}
		}
	}
	public static void update()
	{
		vm02.call(mouseSlot | 0x1410, mouseCtrl); // CALL_FW ReadMouse
	}
	public static int xPos()
	{
		return vm02.peekByte(0x478 + slot) | (vm02.peekByte(0x578 + slot) << 8);
	}
	public static int yPos()
	{
		return vm02.peekByte(0x4F8 + slot) | (vm02.peekByte(0x5F8 + slot) << 8);
	}
	public static int status()
	{
		return vm02.peekByte(0x0778 + slot);
	}
	
	public static void main(String args[])
	{		
		conio.home();
		if (enable())
		{
			conio.println("Using mouse card in slot #" + slot);
		}
		else
		{
			conio.println("Unable to find mouse card");
			return;
		}
		while (!conio.keyPressed())
		{
			update();
			conio.gotoXY(8,6);
			conio.print("X Pos:");  conio.print(xPos());  conio.print("    ");
			conio.gotoXY(8,8);
			conio.print("Y Pos:");  conio.print(yPos());  conio.print("    ");
			conio.gotoXY(8,10);
			conio.print("Status:"); conio.print(status()); conio.print("    ");
		}
		disable();
	}
}